﻿using System;
using VA.TMP.Integration.VIMT.HealthShare.StateObject;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.PipelineSteps.MakeCancelInbound
{
    /// <summary>
    /// Serialize Inbound Request Step.
    /// </summary>
    public class SerializeInboundRequestStep : FilterBase<MakeCancelInboundStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(MakeCancelInboundStateObject state)
        {
            try
            {
                state.SerializedRequestMessage = PipelineUtilities.SerializeInstance(state.RequestMessage);
                Logger.Instance.Info($"INFO: HealthShare Make Cancel Inbound: {state.SerializedRequestMessage}");
            }
            catch (Exception ex)
            {
                throw new Exception($"HealthShare Make Cancel SerializeAppointmentStep Pipeline Error: {ex.Message}", ex.InnerException);
            }
        }
    }
}